//
//  MCPDataStore.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 03/11/08.
//  Copyright 2008 Marketcircle, Inc. All rights reserved.
//

#import "MCDataStore.h"

#import <MCClientServer/MCClientServerDefines.h>


@class MCPModel, MCPDatabaseConnection, MCPDatabaseObjectContext, MCPGenericObject;

@interface MCPDataStore : MCDataStore {

	MCPDatabaseConnection *databaseConnection;
	MCPDatabaseObjectContext *databaseObjectContext;
	
	NSString *hostname;
	NSString *database;
	NSString *username;
	NSString *password;
	
	int port;
}

- (id)initWithModel:(MCPModel *)aModel;

- (MCPDatabaseConnection *)databaseConnection;
- (void)setDatabaseConnection:(MCPDatabaseConnection *)aDatabaseConnection;

- (MCPDatabaseObjectContext *)databaseObjectContext;
- (void)setDatabaseObjectContext:(MCPDatabaseObjectContext *)aDatabaseObjectContext;

- (NSString *)hostname;
- (void)setHostname:(NSString *)anHostname;

- (NSString *)database;
- (void)setDatabase:(NSString *)aDatabase;

- (NSString *)username;
- (void)setUsername:(NSString *)anUsername;

- (NSString *)password;
- (void)setPassword:(NSString *)aPassword;

@property (readwrite) int port;


- (NSString *)databaseID;

- (NSDictionary *)transformations;
- (NSDictionary *)inverseTransformations;

// Subclass methods
- (NSNumber *)maxChangeLogRowid;
- (NSNumber *)loadLastChangeIDForClientID:(NSString *)clientID;
- (NSNumber *)saveLastChangeID:(NSNumber *)rowid forClientID:(NSString *)clientID;
- (void)saveLastSyncDateForClientID:(NSString *)clientID;
- (BOOL)loadReplicationOffset:(NSNumber **)offsetp forClientID:(NSString *)anID replicantStatus:(MCSReplicaStatus)status;

@end
